<?php

require_once './vendor/autoload.php';
require_once 'credentials.php';
require_once 'lib/bigcommerce.php';
require_once 'lib/cm3.php';

use League\Csv\Reader;
use League\Csv\Statement;
use GuzzleHttp\Client;

try {
    $client = new GuzzleHttp\Client([
        'headers' => [ 
            'Accept' => 'application/json',
            'Content-type' => 'application/json',
            'X-Auth-Client' => $authClient,
            'X-Auth-Token' => $authToken,
        ],
    ]);

    $cm3Client = new GuzzleHttp\Client([
        'headers' => [
            'Accept' => 'application/json',
            'Content-type' => 'application/json',
        ],
    ]);

    $cm3 = Cm3::create($client, $cm3Client, $cm3ClientId, $cm3ClientPassword, $cm3BranchNumber);
    $bc = BigCommerce::create($client, $storeId);
    $token = $cm3->getToken();

    $userSupplierHash = $_POST["hash"];
    if (!$userSupplierHash) {
        throw new \Exception('hash is a required field');
    }
    if (!is_string($userSupplierHash) || (preg_match('/^[a-zA-Z0-9_ ]*$/i', $userSupplierHash) !== 1) || strlen($userSupplierHash) > 64) {
        throw new \Exception("Invalid hash");
    }

    $orderId = (int) $_POST['order_id'];
    $returnUrl = $myStoreUrl . '/checkout/order-confirmation';
    $webhookUrl = $myStoreUrl . '/checkout/order-confirmation';

    // Returns to example URL: checkout/order-confirmation?applicationId=CPG9TFTRX&status=accepted&supplierOrderReference=129

    $financeData = $bc->getFinanceDetails($orderId);
    $orderData = $bc->getOrder($orderId);

    $finance = $cm3->applyPbf($hashSecret, $userSupplierHash, $token, $orderData, $financeData, $returnUrl, $webhookUrl);

    header("Content-Type: application/json");
    http_response_code(200);
    echo json_encode([
        'redirect_to' => $finance->url,
        'application_id' => $finance->applicationId,
    ]);
} catch (\Exception $e) {
    header("Content-Type: application/json");
    http_response_code(200);
    error_log($e->getMessage());
    echo json_encode([
        'error' => true,
        'message' => 'Something went wrong',
    ]);
}
