<?php

class Cm3
{
    private $client;
    private $cm3Client;
    private $cm3ClientId;
    private $cm3ClientPassword;
    private $cm3BranchNumber;

    public function __construct($client, $cm3Client, $cm3ClientId, $cm3ClientPassword, $cm3BranchNumber) {
        $this->client = $client;
        $this->cm3Client = $cm3Client;
        $this->cm3ClientId = $cm3ClientId;
        $this->cm3ClientPassword = $cm3ClientPassword;
        $this->cm3BranchNumber = $cm3BranchNumber;
    }

    public static function create($client, $cm3Client, $cm3ClientId, $cm3ClientPassword, $cm3BranchNumber)
    {
        $object = get_called_class();
        return new $object($client, $cm3Client, $cm3ClientId, $cm3ClientPassword, $cm3BranchNumber);
    }
        
    function getToken()
    {
        $response = $this->client->post('https://api.demo.hitachicapitaluk.services/token', [
            'form_params' => [
                'grant_type' => 'client_credentials',
                'client_id' => $this->cm3ClientId,
                'client_secret' => $this->cm3ClientPassword,
            ],
        ]);

        if ($response->getStatusCode() != 200) {
            throw new \Exception('ABORT: Something went wrong: ' . $response->getStatusCode());
        }
        $body = json_decode($response->getBody()->getContents());
        if (!property_exists($body, 'access_token')) {
            throw new \Exception('Could not find access token');
        }
        return $body->access_token;
    }

    function applyPbf($hashSecret, $userSupplierHash, $token, $order, $financeData, $returnUrl, $webhookUrl)
    {
        $financeMessage = json_decode($financeData->message);
        if ($financeMessage === null) {
            throw new \Exception('Unable to decode gift message details to validate PBF details');
        }
        $financeDetails = $financeMessage->fd;

        $hash = hash_hmac('sha256', json_encode($financeDetails), $hashSecret);
        if (!$hash || !$financeMessage->hash || !$userSupplierHash) {
            throw new \Exception('Hash not found. Abort.');
        }
        if ($hash != $financeMessage->hash) {
            throw new \Exception('Incorrect hash. The order may have been changed since the cart was created with finance, or the finance data tampered with. Abort.');
        }
        if ($hash != $userSupplierHash) {
            throw new \Exception('User supplied hash incorrect. User may not have permission to apply finance on this order.');
        }

        $giftCertificateAmount = abs($financeData->amount);
        $json = [
            'applicant' => [
                // 'title' => 'MRS',
                'forename' => $order->billing_address->first_name,
                'surname' => $order->billing_address->last_name,
                // 'dateOfBirth' => '1988-12-29',
                'emailAddress' => $order->billing_address->email,
            ],
            // 'currentAddress' => [
            //     'houseNumber' => '0', // TODO: pull this in
            //     // 'houseName' => 'Apex House',
            //     // 'flatName' => 'Flat 22',
            //     'street' => $order->billing_address->street_1 . ' ' . $order->billing_address->street_2,
            //     'town' => $order->billing_address->city,
            //     'county' => $order->billing_address->state ?: $order->billing_address->city,
            //     'postcode' => $order->billing_address->zip
            // ],
            'loan' => [
                'serviceType' => $this->getServiceId($financeDetails->s) ?: 'IB',
                // 'countdownPeriod' => $financeDetails->df ?: 0, // TODO: omit this when 0 or not set
                'term' => $financeDetails->t,
                'loanAmount' => (string) abs($financeDetails->f),
                'totalCashPrice' => (string) ($order->total_inc_tax + $giftCertificateAmount),
                'deposit' => $financeDetails->d,
                'goodsDescription' => 'eCommerce',
                'apr' => $financeDetails->a,
                'instalment' => $financeDetails->i,
            ],
            'branchId' => $this->cm3BranchNumber,
            // 'deliveryType' => 'CLICK_AND_COLLECT', // If this is set to CLICK_AND_COLLECT, then the delivery address should be added
            // 'deliveryAddress' => [
            //     'houseNumber' => '0', // TODO: pull this in
            //     // 'houseName' => 'Apex House',
            //     // 'flatName' => 'Flat 22',
            //     'street' => $order->billing_address->street_1 . ' ' . $order->billing_address->street_2,
            //     'town' => $order->billing_address->city,
            //     'county' => $order->billing_address->state ?: $order->billing_address->city,
            //     'postcode' => $order->billing_address->zip
            // ],
            'returnUrl' => $returnUrl,
            'webhookUrl' => $webhookUrl,
            'supplierOrderReference' => (string) $order->id
        ];

        if ($order->billing_address->phone) {
            $json['applicant']['phoneNumber'] = $order->billing_address->phone;
        }

        $response = $this->cm3Client->post('https://api.demo.hitachicapitaluk.services/applications/pbf', [
            'json' => $json,
            'headers' => [
                'Content-Type' => 'application/json',
                'Authorization' => 'Bearer ' . $token,
            ],
        ]);
        if ($response->getStatusCode() != 200) {
            $body = json_decode($response->getBody()->getContents());
            var_dump($body);
            throw new \Exception('ABORT: Something went wrong: ' . $response->getStatusCode());
        }
        $body = json_decode($response->getBody()->getContents());
        return $body;
    }

    public function getServices($token)
    {
        $response = $this->cm3Client->get('https://api.demo.hitachicapitaluk.services/branches/' . $this->cm3BranchNumber . '/services', [
            'headers' => [
                'Content-Type' => 'application/json',
                'Authorization' => 'Bearer ' . $token,
            ],
        ]);
        if ($response->getStatusCode() != 200) {
            $body = json_decode($response->getBody()->getContents());
            throw new \Exception('ABORT: Something went wrong: ' . $response->getStatusCode());
        }
        $body = json_decode($response->getBody()->getContents());
        return $body;
    }

    public function getServiceId($service)
    {
        $services = [
            'Interest Bearing' => 'IB',
            'Interest Free' => 'IF',
        ];
        return $services[$service] ?? null;
    }
}
