<?php

require_once './vendor/autoload.php';
require_once 'credentials.php';
require_once 'lib/bigcommerce.php';

use League\Csv\Reader;
use League\Csv\Statement;
use GuzzleHttp\Client;

try {
    $client = new GuzzleHttp\Client([
        'headers' => [ 
            'Accept' => 'application/json',
            'Content-type' => 'application/json',
            'X-Auth-Client' => $authClient,
            'X-Auth-Token' => $authToken,
        ],
    ]);

    $cartId = $_GET["cart_id"];
    $amount = abs($_POST["amount"]) * -1;
    $deposit = preg_replace("/[^0-9.]/", "", $_POST["deposit"]);
    $service = $_POST["service"];
    $term = (int) ($_POST["term"]);
    $deferralterm = (int) ($_POST["deferralterm"] ?? 0);
    $deferralterm = preg_replace("/[^0-9.]/", "", $deferralterm);
    $apr = preg_replace("/[^0-9.]/", "", $_POST["aprResults"]);
    $total = preg_replace("/[^0-9.]/", "", $_POST["totalResults"]);
    $intalment = preg_replace("/[^0-9.]/", "", $_POST["instalmentResults"]);

    $financeData = [
        'deferralterm' => $deferralterm ,
        'total' => $total,
        'apr' => $apr,
        'instalment' => $intalment,
        'deposit' => $deposit,
        'term' => $term,
        'service' => $service,
    ];

    if (!$amount || !is_float(floatval($amount))) {
        throw new \Exception("Invalid loanAmount");
    }

    if (isset($deposit) && !is_float(floatval($deposit))) {
        throw new \Exception("Invalid deposit");
    }

    if ($deposit < 0) {
        throw new \Exception("Deposit can not be negative");
    }

    if ($term <= 0) {
        throw new \Exception("Invalid term");
    }

    if (!is_string($cartId) || (preg_match('/^[0-9A-F]{8}-[0-9A-F]{4}-4[0-9A-F]{3}-[89AB][0-9A-F]{3}-[0-9A-F]{12}$/i', $cartId) !== 1)) {
        throw new \Exception("Invalid cartId");
    }

    if (!is_string($service) || (preg_match('/^[a-zA-Z0-9_ ]*$/i', $service) !== 1) || strlen($service) > 30) {
        throw new \Exception("Invalid service");
    }

    $bc = BigCommerce::create($client, $storeId);

    $cart = $bc->getCart($cartId);
    $cartAmount = $cart->data->cart_amount;

    if ($amount > $cartAmount) {
        throw new \Exception("Loan amount can not be bigger than cart amount");
    }

    $loanAmount = $amount + $deposit;
    $cartData = $bc->getCartData($hashSecret, $cart, $financeData, $loanAmount);
    $order = $bc->createDraftOrder($cartData);

    if (!$order->data->redirect_urls->checkout_url) {
        throw new \Exception("Unable to retrieve checkout url");
    }

    header("Content-Type: application/json");
    http_response_code(200);
    $msg = json_decode($cartData['gift_certificates'][0]['message']);
    echo json_encode([
        'redirect_to' => $order->data->redirect_urls->checkout_url,
        'hash' => $msg->hash ?? null,
    ]);
} catch (\Exception $e) {
    header("Content-Type: application/json");
    http_response_code(200);
    error_log($e->getMessage());
    echo json_encode([
        'error' => true,
        'message' => 'Something went wrong',
    ]);
}
